 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_DASHBOARD_VENDAS_GERAL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_DASHBOARD_VENDAS_GERAL]
GO
--EXEC P_DASHBOARD_VENDAS_GERAL 1,'','2017-12-01','2017-12-31'
CREATE PROCEDURE P_DASHBOARD_VENDAS_GERAL (@CD_EMP INT, @CD_FILIAL VARCHAR(MAX)='',@DT_INI DATETIME, @DT_FIM DATETIME)
AS
CREATE TABLE #_RS_FILIAL (CD_EMP INT, CD_FILIAL	INT)

IF LTRIM(RTRIM(@CD_FILIAL))<>''
BEGIN
INSERT INTO #_RS_FILIAL 						
SELECT @CD_EMP, 
	ID 
FROM 
	UFD_PRM_IN_STRING(@CD_FILIAL)
END
ELSE
BEGIN
	INSERT INTO #_RS_FILIAL 						
	SELECT 
		CD_EMP,
		CD_FILIAL
	FROM 
		PRC_FILIAL
	WHERE
		CD_EMP = @CD_EMP
END

CREATE TABLE #RsMovimento(VLR_VENDA_LIQUIDA			MONEY,
						  VLR_VENDA_BRUTA			MONEY,
						  VLR_CUSTO_MEDIO			MONEY,
						  QTDE_CUPONS_ITENS			INT,
						  VLR_DESC_VERBA			MONEY,
						  VLR_DESC_ITENS			MONEY,
						  VLR_OFERTA				MONEY,
						  VLR_DESC_TOT				MONEY,
						  VLR_VENDA_PMC				MONEY,
						  PERC_MARGEM				MONEY,
						  PERC_CMV					MONEY,
						  VLR_MARGEM				MONEY)

CREATE TABLE #RsMeta (VLR_VENDA_META			MONEY,
					  QTDE_CUPONS_META			INT,
					  QTE_CUPONS_ITENS_META		INT,
					  PERC_LUCRATIVIDADE		MONEY)

CREATE TABLE #RsMovimentoTicket (QTDE_CUPONS MONEY)

INSERT INTO #RsMovimento
	(VLR_VENDA_LIQUIDA,
	VLR_VENDA_BRUTA,
	VLR_CUSTO_MEDIO,
	QTDE_CUPONS_ITENS,
	VLR_DESC_VERBA,
	VLR_DESC_ITENS,
	VLR_OFERTA,
	VLR_DESC_TOT,
	VLR_VENDA_PMC,
	PERC_MARGEM,
	PERC_CMV,
	VLR_MARGEM)

SELECT 
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ),2), 
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD),2), 
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_MD),2), 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.QTDE_ITENS),
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_VERBA),2),
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_ITENS),2),
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_OFERTA),2),
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_VERBA+EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_ITENS+EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_OFERTA),2) AS VLR_DESC_TOTAL,
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_PMC),2),
	CASE WHEN ISNULL(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ),0) > 0 THEN
		(ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ-EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_MD),2) / ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ),2))*100
	ELSE
		0
	END,
	CASE WHEN ISNULL(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ),0) > 0 THEN
		100 - (ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ-EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_MD),2) / ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ),2))*100
	ELSE
		0
	END,
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ-EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_MD),2)
FROM            
	EST_MOVIMENTO_VENDAS_PRODUTOS INNER JOIN EST_MOVIMENTO_VENDAS ON
	EST_MOVIMENTO_VENDAS_PRODUTOS.CD_CTR_VENDAS = EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
	INNER JOIN GLB_DT_MOVIMENTO ON
	EST_MOVIMENTO_VENDAS.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
	INNER JOIN #_RS_FILIAL f ON
	EST_MOVIMENTO_VENDAS.CD_FILIAL = f.CD_FILIAL
WHERE
	EST_MOVIMENTO_VENDAS.TIPO_VENDA IN (0,2,3,10,11)
	AND GLB_DT_MOVIMENTO.DT_MOVIMENTO BETWEEN @DT_INI AND @DT_FIM

INSERT INTO #RsMovimentoTicket
SELECT 
	SUM(EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS.QTDE_VD)
FROM            
	EST_MOVIMENTO_VENDAS INNER JOIN GLB_DT_MOVIMENTO ON
	EST_MOVIMENTO_VENDAS.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
	INNER JOIN EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS ON 
	EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS = EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS.CD_CTR_VENDAS AND
	EST_MOVIMENTO_VENDAS.CD_CTR_DT_MOVIMENTO = EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS.CD_CTR_DT_MOVIMENTO 
	INNER JOIN #_RS_FILIAL f ON
	EST_MOVIMENTO_VENDAS.CD_FILIAL = f.CD_FILIAL
WHERE
	EST_MOVIMENTO_VENDAS.TIPO_VENDA IN (0,2,3,10,11)
	AND GLB_DT_MOVIMENTO.DT_MOVIMENTO BETWEEN @DT_INI AND @DT_FIM

INSERT INTO #RsMeta (VLR_VENDA_META,
					  QTDE_CUPONS_META,
					  QTE_CUPONS_ITENS_META,
					  PERC_LUCRATIVIDADE)
SELECT
	SUM(EST_META_FILIAL_CPL.VLR_VD)		META_VD,
	SUM(EST_META_FILIAL_CPL.QTDE_CUPONS)	META_CUPONS,
	SUM(EST_META_FILIAL_CPL.QTDE_ITENS)	META_ITENS,
	MAX(mf.PERC_LUCRATIVIDADE)
FROM		
	EST_META_FILIAL_CPL INNER JOIN #_RS_FILIAL f ON
	EST_META_FILIAL_CPL.CD_EMP = f.CD_EMP AND
	EST_META_FILIAL_CPL.CD_FILIAL = f.CD_FILIAL 
	INNER JOIN EST_META_FILIAL MF ON
	EST_META_FILIAL_CPL.CD_EMP           = MF.CD_EMP AND
	EST_META_FILIAL_CPL.CD_FILIAL        = MF.CD_FILIAL AND
	EST_META_FILIAL_CPL.CD_META_FILIAL   = MF.CD_META_FILIAL
WHERE
	EST_META_FILIAL_CPL.DT_META  BETWEEN @DT_INI AND @DT_FIM


SELECT 
	m.VLR_VENDA_LIQUIDA,
	m.VLR_VENDA_BRUTA,
	m.VLR_CUSTO_MEDIO,
	m.QTDE_CUPONS_ITENS,
	m.VLR_DESC_VERBA,
	m.VLR_DESC_ITENS,
	m.VLR_OFERTA,
	m.VLR_DESC_TOT,
	m.VLR_VENDA_PMC,
	m.PERC_MARGEM,
	m.PERC_CMV,
	m.VLR_MARGEM,
	t.QTDE_CUPONS,
	meta.VLR_VENDA_META,
	meta.QTDE_CUPONS_META,
	meta.QTE_CUPONS_ITENS_META,
	meta.PERC_LUCRATIVIDADE
FROM 
	#RsMovimento m,
	#RsMovimentoTicket t,
	#RsMeta meta

DROP TABLE #RsMovimento;	 	 
DROP TABLE #RsMovimentoTicket;
DROP TABLE #_RS_FILIAL;